/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.demonmobs.entity;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.api.IGroupFire;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.entity.EntityProjectileBase;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.demonmobs.entity.EntityBehemoth;
import com.lycanitesmobs.demonmobs.entity.EntityBelph;
import com.lycanitesmobs.demonmobs.entity.EntityHellfireBarrier;
import com.lycanitesmobs.demonmobs.entity.EntityHellfireOrb;
import com.lycanitesmobs.demonmobs.entity.EntityHellfireWave;
import com.lycanitesmobs.demonmobs.entity.EntityHellfireball;
import com.lycanitesmobs.demonmobs.entity.EntityNetherSoul;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRahovart
extends EntityCreatureBase
implements IMob,
IGroupDemon {
    public List<EntityPlayer> playerTargets = new ArrayList<EntityPlayer>();
    public int hellfireEnergy = 0;
    public List<EntityHellfireOrb> hellfireOrbs = new ArrayList<EntityHellfireOrb>();
    protected static final DataParameter<Integer> HELLFIRE_ENERGY = EntityDataManager.func_187226_a(EntityCreatureBase.class, (DataSerializer)DataSerializers.field_187192_b);
    public List<EntityBelph> hellfireBelphMinions = new ArrayList<EntityBelph>();
    public List<EntityBehemoth> hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
    public int hellfireWallTime = 0;
    public int hellfireWallTimeMax = 400;
    public boolean hellfireWallClockwise = false;
    public EntityHellfireBarrier hellfireWallLeft;
    public EntityHellfireBarrier hellfireWallRight;
    public List<EntityHellfireBarrier> hellfireBarriers = new ArrayList<EntityHellfireBarrier>();
    public int hellfireBarrierHealth = 100;
    public float damageTakenThisSec = 0.0f;
    public float healthLastTick = -1.0f;

    public EntityRahovart(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.defense = 2;
        this.experience = 1000;
        this.hasAttackSound = false;
        this.justAttackedTime = (short)40;
        this.setWidth = 7.0f;
        this.setHeight = 25.0f;
        this.solidCollision = true;
        this.field_70144_Y = 1.0f;
        this.setupMob();
        this.hitAreaWidthScale = 2.0f;
        this.boss = true;
        this.damageMax = 25;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityBelph.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityBehemoth.class));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpClasses(EntityNetherSoul.class));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 5000.0);
        baseAttributes.put("movementSpeed", 0.32);
        baseAttributes.put("knockbackResistance", 1.0);
        baseAttributes.put("followRange", 40.0);
        baseAttributes.put("attackDamage", 18.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(Items.field_151065_br), 1.0f).setMinAmount(20).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(Items.field_151072_bj), 1.0f).setMinAmount(10).setMaxAmount(20));
        this.drops.add(new DropRate(new ItemStack(Items.field_151045_i), 1.0f).setMinAmount(10).setMaxAmount(20));
        this.drops.add(new DropRate(new ItemStack(Items.field_151156_bN), 1.0f).setMinAmount(1).setMaxAmount(8));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("doomfirecharge")), 1.0f).setMinAmount(20).setMaxAmount(100));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("hellfirecharge")), 1.0f).setMinAmount(10).setMaxAmount(50));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("soulstonedemonic")), 1.0f).setMinAmount(1).setMaxAmount(3));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstone")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstonebrick")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demonstonetile")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getBlock("demoncrystal")), 1.0f).setMinAmount(64).setMaxAmount(128));
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("nethersoulsigil")), 1.0f).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_72314_b(10.0, 50.0, 10.0).func_72317_d(0.0, 25.0, 0.0);
    }

    @Override
    public void setArenaCenter(BlockPos pos) {
        super.setArenaCenter(pos);
    }

    @Override
    public void func_70636_d() {
        if (this.healthLastTick < 0.0f) {
            this.healthLastTick = this.func_110143_aJ();
        }
        if (this.healthLastTick - this.func_110143_aJ() > 50.0f) {
            this.func_70606_j(this.healthLastTick);
        }
        this.healthLastTick = this.func_110143_aJ();
        if (!this.field_70170_p.field_72995_K && this.updateTick % 20L == 0L) {
            this.damageTakenThisSec = 0.0f;
        }
        super.func_70636_d();
        if (this.hasAttackTarget() && !this.field_70170_p.field_72995_K) {
            this.func_70671_ap().func_75651_a((Entity)this.func_70638_az(), 30.0f, 30.0f);
        }
        if (this.hasArenaCenter()) {
            BlockPos arenaPos = this.getArenaCenter();
            double arenaY = this.field_70163_u;
            if (this.field_70170_p.func_175623_d(arenaPos)) {
                arenaY = arenaPos.func_177956_o();
            } else if (this.field_70170_p.func_175623_d(arenaPos.func_177982_a(0, 1, 0))) {
                arenaY = arenaPos.func_177982_a(0, 1, 0).func_177956_o();
            }
            if (this.field_70165_t != (double)arenaPos.func_177958_n() || this.field_70163_u != arenaY || this.field_70161_v != (double)arenaPos.func_177952_p()) {
                this.func_70107_b(arenaPos.func_177958_n(), arenaY, arenaPos.func_177952_p());
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(HELLFIRE_ENERGY, (Object)this.hellfireEnergy);
        } else {
            this.hellfireEnergy = (Integer)this.field_70180_af.func_187225_a(HELLFIRE_ENERGY);
        }
        EntityRahovart.updateHellfireOrbs((EntityLivingBase)this, this.updateTick, 5, this.hellfireEnergy, 10.0f, this.hellfireOrbs);
        if (!this.field_70170_p.field_72995_K) {
            this.updatePhases();
        }
        if (!this.field_70170_p.field_72995_K && this.updateTick % 200L == 0L) {
            this.playerTargets = this.getNearbyEntities(EntityPlayer.class, null, 64.0);
        }
        if (!this.field_70170_p.field_72995_K && this.updateTick % 20L == 0L && this.playerTargets.size() == 0) {
            this.func_70691_i(50.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.updateTick % 20L == 0L) {
            for (int i = 0; i < 3; ++i) {
                EntityHellfireball projectile = new EntityHellfireball(this.field_70170_p, (EntityLivingBase)this);
                projectile.setProjectileScale(8.0f);
                projectile.func_70186_c(this.func_70681_au().nextFloat() - 0.5f, this.func_70681_au().nextFloat(), this.func_70681_au().nextFloat() - 0.5f, 1.2f, 3.0f);
                this.func_184185_a(((EntityProjectileBase)projectile).getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)projectile);
            }
            for (EntityPlayer target : this.playerTargets) {
                if (target.field_71075_bZ.field_75098_d || target.func_175149_v()) continue;
                this.rangedAttack((Entity)target, 1.0f);
                if (!(target.field_70163_u > this.field_70163_u + MobInfo.bossAntiFlight)) continue;
                for (int i = 0; i < 3; ++i) {
                    EntityNetherSoul minion = new EntityNetherSoul(this.func_130014_f_());
                    this.summonMinion((EntityLivingBase)minion, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    minion.func_70624_b((EntityLivingBase)target);
                    minion.setMasterTarget(null);
                }
            }
            if (this.hasAttackTarget()) {
                this.rangedAttack((Entity)this.func_70638_az(), 1.0f);
            }
        }
    }

    public void updatePhases() {
        int summonCount;
        if (this.getBattlePhase() == 0) {
            if (!this.hellfireBehemothMinions.isEmpty()) {
                for (EntityBehemoth entityBehemoth : this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()])) {
                    entityBehemoth.hellfireEnergy = 0;
                }
                this.hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
            }
            this.hellfireWallTime = 0;
            this.hellfireBarrierCleanup();
            if (this.updateTick % 20L == 0L) {
                for (EntityCreatureTameable entityCreatureTameable : this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()])) {
                    if (((EntityBelph)entityCreatureTameable).field_70128_L) {
                        this.onMinionDeath((EntityLivingBase)entityCreatureTameable);
                        continue;
                    }
                    ((EntityBelph)entityCreatureTameable).hellfireEnergy += 5;
                    if (((EntityBelph)entityCreatureTameable).hellfireEnergy < 100) continue;
                    this.hellfireEnergy += 20;
                    this.onMinionDeath((EntityLivingBase)entityCreatureTameable);
                    this.field_70170_p.func_72876_a((Entity)entityCreatureTameable, ((EntityBelph)entityCreatureTameable).field_70165_t, ((EntityBelph)entityCreatureTameable).field_70163_u, ((EntityBelph)entityCreatureTameable).field_70161_v, 1.0f, false);
                    ((EntityBelph)entityCreatureTameable).hellfireEnergy = 0;
                    entityCreatureTameable.func_70106_y();
                }
            }
            if (this.hellfireEnergy >= 100) {
                this.hellfireEnergy = 0;
                double angle = this.func_70681_au().nextFloat() * 360.0f;
                if (this.hasAttackTarget()) {
                    double deltaX = this.func_70638_az().field_70165_t - this.field_70165_t;
                    double deltaZ = this.func_70638_az().field_70161_v - this.field_70161_v;
                    angle = Math.atan2(deltaZ, deltaX) * 180.0 / Math.PI;
                }
                this.hellfireWaveAttack(angle);
            }
            if (this.updateTick % 100L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBelph minion3 = new EntityBelph(this.field_70170_p);
                        this.summonMinion((EntityLivingBase)minion3, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBelphMinions.add(minion3);
                    }
                }
            }
        }
        if (this.getBattlePhase() == 1) {
            if (!this.hellfireBelphMinions.isEmpty()) {
                EntityBelph[] summonAmount = this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion3 = 0; minion3 < summonCount; ++minion3) {
                    EntityBelph entityBelph = summonAmount[minion3];
                    entityBelph.hellfireEnergy = 0;
                }
                this.hellfireBelphMinions = new ArrayList<EntityBelph>();
            }
            this.hellfireBarrierCleanup();
            if (this.hellfireWallTime <= 0 && this.updateTick % 20L == 0L) {
                EntityBehemoth[] summonAmount = this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion3 = 0; minion3 < summonCount; ++minion3) {
                    EntityBehemoth entityBehemoth = summonAmount[minion3];
                    if (entityBehemoth.field_70128_L) {
                        this.onMinionDeath((EntityLivingBase)entityBehemoth);
                        continue;
                    }
                    entityBehemoth.hellfireEnergy += 5;
                    if (entityBehemoth.hellfireEnergy < 100) continue;
                    this.hellfireEnergy += 20;
                    this.onMinionDeath((EntityLivingBase)entityBehemoth);
                    this.field_70170_p.func_72876_a((Entity)entityBehemoth, entityBehemoth.field_70165_t, entityBehemoth.field_70163_u, entityBehemoth.field_70161_v, 1.0f, false);
                    entityBehemoth.hellfireEnergy = 0;
                    entityBehemoth.func_70106_y();
                }
            }
            if (this.hellfireEnergy >= 100) {
                this.hellfireEnergy = 0;
                this.hellfireWallAttack(this.field_70177_z);
            }
            if (this.hellfireWallTime > 0) {
                this.hellfireWallUpdate();
                --this.hellfireWallTime;
            }
            if (this.updateTick % 400L == 0L) {
                int summonAmount = 2;
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBehemoth minion4 = new EntityBehemoth(this.field_70170_p);
                        this.summonMinion((EntityLivingBase)minion4, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBehemothMinions.add(minion4);
                    }
                }
            }
            if (this.updateTick % 200L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4) - 1;
                for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                    EntityBelph minion5 = new EntityBelph(this.field_70170_p);
                    this.summonMinion((EntityLivingBase)minion5, this.func_70681_au().nextDouble() * 360.0, 5.0);
                }
            }
        }
        if (this.getBattlePhase() >= 2) {
            if (!this.hellfireBelphMinions.isEmpty()) {
                EntityBelph[] summonAmount = this.hellfireBelphMinions.toArray(new EntityBelph[this.hellfireBelphMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion5 = 0; minion5 < summonCount; ++minion5) {
                    EntityBelph entityBelph = summonAmount[minion5];
                    entityBelph.hellfireEnergy = 0;
                }
                this.hellfireBelphMinions = new ArrayList<EntityBelph>();
            }
            if (!this.hellfireBehemothMinions.isEmpty()) {
                EntityBehemoth[] summonAmount = this.hellfireBehemothMinions.toArray(new EntityBehemoth[this.hellfireBehemothMinions.size()]);
                summonCount = summonAmount.length;
                for (int minion5 = 0; minion5 < summonCount; ++minion5) {
                    EntityBehemoth entityBehemoth = summonAmount[minion5];
                    entityBehemoth.hellfireEnergy = 0;
                }
                this.hellfireBehemothMinions = new ArrayList<EntityBehemoth>();
            }
            this.hellfireWallTime = 0;
            if (this.updateTick % 20L == 0L && this.hellfireEnergy < 100) {
                this.hellfireEnergy += 5;
            }
            if (this.hellfireEnergy >= 100 && this.hellfireBarriers.size() < 20) {
                this.hellfireEnergy = 0;
                this.hellfireBarrierAttack(360.0f * this.func_70681_au().nextFloat());
            }
            if (this.hellfireBarriers.size() > 0) {
                this.hellfireBarrierUpdate();
            }
            if (this.updateTick % 200L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(2);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBehemoth minion6 = new EntityBehemoth(this.field_70170_p);
                        this.summonMinion((EntityLivingBase)minion6, this.func_70681_au().nextDouble() * 360.0, 5.0);
                        this.hellfireBehemothMinions.add(minion6);
                    }
                }
            }
            if (this.updateTick % 400L == 0L) {
                int summonAmount = this.func_70681_au().nextInt(4);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityBelph minion7 = new EntityBelph(this.field_70170_p);
                        this.summonMinion((EntityLivingBase)minion7, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    }
                }
                summonAmount = this.func_70681_au().nextInt(3);
                if ((summonAmount *= this.playerTargets.size()) > 0) {
                    for (summonCount = 0; summonCount <= summonAmount; ++summonCount) {
                        EntityNetherSoul minion8 = new EntityNetherSoul(this.field_70170_p);
                        this.summonMinion((EntityLivingBase)minion8, this.func_70681_au().nextDouble() * 360.0, 5.0);
                    }
                }
            }
        }
        if (this.hellfireWallTime <= 0) {
            this.hellfireWallCleanup();
        }
    }

    @Override
    public void onMinionDeath(EntityLivingBase minion) {
        if (minion instanceof EntityBelph && this.hellfireBelphMinions.contains(minion)) {
            this.hellfireBelphMinions.remove(minion);
            return;
        }
        if (minion instanceof EntityBehemoth && this.hellfireBehemothMinions.contains(minion)) {
            this.hellfireBehemothMinions.remove(minion);
            return;
        }
        if (this.hellfireBarriers.size() > 0) {
            this.hellfireBarrierHealth = minion instanceof EntityBehemoth ? (this.hellfireBarrierHealth -= 100) : (this.hellfireBarrierHealth -= 50);
        }
    }

    @Override
    public void updateBattlePhase() {
        double healthNormal = this.func_110143_aJ() / this.func_110138_aP();
        if (healthNormal <= 0.2) {
            this.setBattlePhase(2);
            return;
        }
        if (healthNormal <= 0.6) {
            this.setBattlePhase(1);
            return;
        }
        this.setBattlePhase(0);
    }

    public static void updateHellfireOrbs(EntityLivingBase entity, long orbTick, int hellfireOrbMax, int hellfireOrbEnergy, float orbSize, List<EntityHellfireOrb> hellfireOrbs) {
        if (!entity.field_70170_p.field_72995_K) {
            return;
        }
        int hellfireChargeCount = Math.round((float)Math.min(hellfireOrbEnergy, 100) / (100.0f / (float)hellfireOrbMax));
        int hellfireOrbRotationTime = 100;
        double hellfireOrbAngle = 360.0f * ((float)(orbTick % (long)hellfireOrbRotationTime) / (float)hellfireOrbRotationTime);
        double hellfireOrbAngleOffset = 360.0 / (double)hellfireOrbMax;
        while (hellfireOrbs.size() < hellfireChargeCount) {
            EntityHellfireOrb hellfireOrb = new EntityHellfireOrb(entity.field_70170_p, entity);
            hellfireOrb.clientOnly = true;
            hellfireOrbs.add(hellfireOrb);
            entity.field_70170_p.func_72838_d((Entity)hellfireOrb);
            hellfireOrb.setProjectileScale(orbSize);
        }
        while (hellfireOrbs.size() > hellfireChargeCount) {
            hellfireOrbs.get(hellfireOrbs.size() - 1).func_70106_y();
            hellfireOrbs.remove(hellfireOrbs.size() - 1);
        }
        for (int i = 0; i < hellfireOrbs.size(); ++i) {
            EntityHellfireOrb hellfireOrb = hellfireOrbs.get(i);
            double rotationRadians = Math.toRadians((hellfireOrbAngle + hellfireOrbAngleOffset * (double)i) % 360.0);
            double x = (double)entity.field_70130_N * 1.25 * Math.cos(rotationRadians) + Math.sin(rotationRadians);
            double z = (double)entity.field_70130_N * 1.25 * Math.sin(rotationRadians) - Math.cos(rotationRadians);
            hellfireOrb.field_70165_t = entity.field_70165_t - x;
            hellfireOrb.field_70163_u = entity.field_70163_u + (double)(entity.field_70131_O * 0.75f);
            hellfireOrb.field_70161_v = entity.field_70161_v - z;
            hellfireOrb.func_70107_b(entity.field_70165_t - x, entity.field_70163_u + (double)(entity.field_70131_O * 0.75f), entity.field_70161_v - z);
            hellfireOrb.projectileLife = 5;
        }
    }

    @Override
    public boolean func_70686_a(Class targetClass) {
        if (targetClass.isAssignableFrom(EntityBelph.class)) {
            return false;
        }
        return super.func_70686_a(targetClass);
    }

    @Override
    public boolean canAttackEntity(EntityLivingBase targetEntity) {
        if (targetEntity instanceof IGroupDemon || targetEntity instanceof IGroupFire) {
            if (targetEntity instanceof EntityCreatureTameable) {
                return ((EntityCreatureTameable)targetEntity).func_70902_q() instanceof EntityPlayer;
            }
            return false;
        }
        return super.canAttackEntity(targetEntity);
    }

    @Override
    public void rangedAttack(Entity target, float range) {
        EntityHellfireball projectile = new EntityHellfireball(this.field_70170_p, (EntityLivingBase)this);
        projectile.setProjectileScale(8.0f);
        if (!(target instanceof EntityPlayer)) {
            projectile.setBaseDamage(20);
        }
        projectile.field_70163_u -= (double)(this.field_70131_O * 0.25f);
        float accuracy = 1.0f * (this.func_70681_au().nextFloat() - 0.5f);
        double d0 = target.field_70165_t - this.field_70165_t + (double)accuracy;
        double d1 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f - projectile.field_70163_u + (double)accuracy;
        double d2 = target.field_70161_v - this.field_70161_v + (double)accuracy;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        float velocity = 1.2f;
        projectile.func_70186_c(d0, d1 + (double)f1, d2, velocity, 6.0f);
        this.func_184185_a(projectile.getLaunchSound(), 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)projectile);
        super.rangedAttack(target, range);
    }

    public void hellfireWaveAttack(double angle) {
        this.setJustAttacked();
        this.playAttackSound();
        EntityHellfireWave hellfireWave = new EntityHellfireWave(this.field_70170_p, (EntityLivingBase)this);
        hellfireWave.field_70163_u = this.field_70163_u;
        hellfireWave.rotation = angle;
        this.field_70170_p.func_72838_d((Entity)hellfireWave);
    }

    public void hellfireWallAttack(double angle) {
        this.playAttackSound();
        this.setJustAttacked();
        this.hellfireWallTime = this.hellfireWallTimeMax;
        this.hellfireWallClockwise = this.func_70681_au().nextBoolean();
    }

    public void hellfireWallUpdate() {
        this.setJustAttacked();
        double hellfireWallNormal = (double)this.hellfireWallTime / (double)this.hellfireWallTimeMax;
        double hellfireWallAngle = 360.0;
        if (this.hellfireWallClockwise) {
            hellfireWallAngle = -360.0;
        }
        if (this.hellfireWallLeft == null) {
            this.hellfireWallLeft = new EntityHellfireBarrier(this.field_70170_p, (EntityLivingBase)this);
            this.hellfireWallLeft.wall = true;
            this.field_70170_p.func_72838_d((Entity)this.hellfireWallLeft);
        }
        this.hellfireWallLeft.time = 0;
        this.hellfireWallLeft.field_70165_t = this.field_70165_t;
        this.hellfireWallLeft.field_70163_u = this.field_70163_u;
        this.hellfireWallLeft.field_70161_v = this.field_70161_v;
        this.hellfireWallLeft.rotation = hellfireWallNormal * hellfireWallAngle;
        if (this.hellfireWallRight == null) {
            this.hellfireWallRight = new EntityHellfireBarrier(this.field_70170_p, (EntityLivingBase)this);
            this.hellfireWallRight.wall = true;
            this.field_70170_p.func_72838_d((Entity)this.hellfireWallRight);
        }
        this.hellfireWallRight.time = 0;
        this.hellfireWallRight.field_70165_t = this.field_70165_t;
        this.hellfireWallRight.field_70163_u = this.field_70163_u;
        this.hellfireWallRight.field_70161_v = this.field_70161_v;
        this.hellfireWallRight.rotation = 180.0 + hellfireWallNormal * hellfireWallAngle;
    }

    public void hellfireWallCleanup() {
        if (this.hellfireWallLeft != null) {
            this.hellfireWallLeft.func_70106_y();
            this.hellfireWallLeft = null;
        }
        if (this.hellfireWallRight != null) {
            this.hellfireWallRight.func_70106_y();
            this.hellfireWallRight = null;
        }
    }

    public void hellfireBarrierAttack(double angle) {
        this.setJustAttacked();
        this.playAttackSound();
        EntityHellfireBarrier hellfireBarrier = new EntityHellfireBarrier(this.field_70170_p, (EntityLivingBase)this);
        this.field_70170_p.func_72838_d((Entity)hellfireBarrier);
        hellfireBarrier.time = 0;
        hellfireBarrier.field_70165_t = this.field_70165_t;
        hellfireBarrier.field_70163_u = this.field_70163_u;
        hellfireBarrier.field_70161_v = this.field_70161_v;
        hellfireBarrier.rotation = angle;
        this.hellfireBarriers.add(hellfireBarrier);
    }

    public void hellfireBarrierUpdate() {
        if (this.hellfireBarrierHealth <= 0) {
            this.hellfireBarrierHealth = 100;
            if (this.hellfireBarriers.size() > 0) {
                EntityHellfireBarrier hellfireBarrier = this.hellfireBarriers.get(this.hellfireBarriers.size() - 1);
                hellfireBarrier.func_70106_y();
                this.hellfireBarriers.remove(this.hellfireBarriers.size() - 1);
            }
        }
        for (EntityHellfireBarrier hellfireBarrier : this.hellfireBarriers) {
            hellfireBarrier.time = 0;
            hellfireBarrier.field_70165_t = this.field_70165_t;
            hellfireBarrier.field_70163_u = this.field_70163_u;
            hellfireBarrier.field_70161_v = this.field_70161_v;
        }
    }

    public void hellfireBarrierCleanup() {
        if (this.field_70170_p.field_72995_K || this.hellfireBarriers.size() < 1) {
            return;
        }
        for (EntityHellfireBarrier hellfireBarrier : this.hellfireBarriers) {
            hellfireBarrier.func_70106_y();
        }
        this.hellfireBarriers = new ArrayList<EntityHellfireBarrier>();
        this.hellfireBarrierHealth = 100;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public boolean func_180431_b(DamageSource source) {
        if (this.damageTakenThisSec >= 50.0f) {
            return true;
        }
        return super.func_180431_b(source);
    }

    @Override
    public void onDamage(DamageSource damageSrc, float damage) {
        this.damageTakenThisSec += damage;
        super.onDamage(damageSrc, damage);
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_82731_v) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public boolean isDamageEntityApplicable(Entity entity) {
        if (entity instanceof EntityPigZombie) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityIronGolem) {
            entity.func_70106_y();
            return false;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!player.field_71075_bZ.field_75098_d && player.field_70163_u > this.field_70163_u + MobInfo.bossAntiFlight) {
                return false;
            }
        }
        return super.isDamageEntityApplicable(entity);
    }

    @Override
    public boolean func_70097_a(DamageSource damageSrc, float damage) {
        if (this.playerTargets != null && damageSrc.func_76346_g() != null && damageSrc.func_76346_g() instanceof EntityPlayer && !this.playerTargets.contains(damageSrc.func_76346_g())) {
            this.playerTargets.add((EntityPlayer)damageSrc.func_76346_g());
        }
        return super.func_70097_a(damageSrc, damage);
    }

    @Override
    public void func_70037_a(NBTTagCompound nbtTagCompound) {
        Entity entity;
        int i;
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("HellfireEnergy")) {
            this.hellfireEnergy = nbtTagCompound.func_74762_e("HellfireEnergy");
        }
        if (nbtTagCompound.func_74764_b("HellfireWallTime")) {
            this.hellfireWallTime = nbtTagCompound.func_74762_e("HellfireWallTime");
        }
        if (nbtTagCompound.func_74764_b("BelphIDs")) {
            NBTTagList belphIDs = nbtTagCompound.func_150295_c("BelphIDs", 10);
            for (i = 0; i < belphIDs.func_74745_c(); ++i) {
                NBTTagCompound belphID = belphIDs.func_150305_b(i);
                if (!belphID.func_74764_b("ID") || (entity = this.field_70170_p.func_73045_a(belphID.func_74762_e("ID"))) == null || !(entity instanceof EntityBelph)) continue;
                this.hellfireBelphMinions.add((EntityBelph)entity);
            }
        }
        if (nbtTagCompound.func_74764_b("BehemothIDs")) {
            NBTTagList behemothIDs = nbtTagCompound.func_150295_c("BehemothIDs", 10);
            for (i = 0; i < behemothIDs.func_74745_c(); ++i) {
                NBTTagCompound behemothID = behemothIDs.func_150305_b(i);
                if (!behemothID.func_74764_b("ID") || (entity = this.field_70170_p.func_73045_a(behemothID.func_74762_e("ID"))) == null || !(entity instanceof EntityBehemoth)) continue;
                this.hellfireBehemothMinions.add((EntityBehemoth)entity);
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nbtTagCompound) {
        super.func_70014_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("HellfireEnergy", this.hellfireEnergy);
        nbtTagCompound.func_74768_a("HellfireWallTime", this.hellfireWallTime);
        if (this.getBattlePhase() == 0) {
            NBTTagList belphIDs = new NBTTagList();
            for (EntityBelph entityBelph : this.hellfireBelphMinions) {
                NBTTagCompound belphID = new NBTTagCompound();
                belphID.func_74768_a("ID", entityBelph.func_145782_y());
                belphIDs.func_74742_a((NBTBase)belphID);
            }
            nbtTagCompound.func_74782_a("BelphIDs", (NBTBase)belphIDs);
        }
        if (this.getBattlePhase() == 1) {
            NBTTagList behemothIDs = new NBTTagList();
            for (EntityBehemoth entityBehemoth : this.hellfireBehemothMinions) {
                NBTTagCompound behemothID = new NBTTagCompound();
                behemothID.func_74768_a("ID", entityBehemoth.func_145782_y());
                behemothIDs.func_74742_a((NBTBase)behemothID);
            }
            nbtTagCompound.func_74782_a("BehemothIDs", (NBTBase)behemothIDs);
        }
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block block) {
        if (this.hasArenaCenter()) {
            return;
        }
        super.func_180429_a(pos, block);
    }

    public float func_70013_c(float par1) {
        return 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        return 0xF000F0;
    }
}

